// Green wavesMod01.fsh
//https://glslsandbox.com/e#78032.0
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
//

#define time u_Elapsed  //*0.1666
#define resolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define mouse vec4(0.0,0.0, 0.0,0.0)




#ifdef GL_ES
precision highp float;
#endif

//uniform vec2 resolution;
//uniform float time;

// https://codepen.io/ilithya/pen/ZEBKePQ
#define PI 3.14159265359

void main (void) {
	vec2 uv = (gl_FragCoord.xy - resolution.x * .5) / resolution.yy + 0.5;
	
	float t = time*0.2;
	float n = 2.;
	float cAnim = sin(time*0.25); // Same anim as particles 	
	
	vec3 c1 = vec3(0.0);
	vec3 c2 = vec3(0.29+cAnim, 0.50-cAnim, 0.68+cAnim);
	float wave = fract(sin(uv.x*n+t) + uv.y*n+sin(t*.5));
	
	vec3 color = vec3(wave, uv.y, 0.75);
	color *= mix(c1, c2, vec3(wave));
	
    gl_FragColor = vec4(color, 1.0);
}
